  MONTHaxis<-function(X, DAYS=FALSE)
    {
      if(missing(DAYS)) { DAYS= FALSE }
      RX = range(X)
      
      xyr = unique(floor( range(X) ))
      
      syr = seq(from=min(xyr), to=max(xyr), by=1)
      dpyr = RSEIS::DAYSperYEAR(syr)
      dpyrM = matrix(rep(dpyr, times=12), nrow=12, byrow=TRUE)

      
      moyears = RPMG::meshgrid(syr, 1:12)

      jdyears = RSEIS::getjul(moyears$x, moyears$y, 1 )

      jdyears = jdyears/dpyrM
      
      myjd = moyears$x + jdyears
      

      
      Month.Names  = c("Jan", 'Feb', 'Mar','Apr', 'May',  'Jun',
        'Jul', 'Aug', 'Sep','Oct','Nov', 'Dec')

      WRX = which(myjd>=RX [1] & myjd<=RX[2])

      jdat = myjd[WRX]
      yearat = moyears$x[WRX]
      moat = Month.Names[moyears$y[WRX]]
      yrmolab = moat 
      ##  yrmolab = paste(sep="/", yearat, moat)

      if(length(yrmolab)>11)
        {
          yrmolab[moat=="Jan"] =  paste(sep="/", yearat[moat=="Jan"], moat[moat=="Jan"])
        }
      else
        {
          
          yrmolab[moat=="Jan"] =  paste(sep="/", yearat[moat=="Jan"], moat[moat=="Jan"])
          yrmolab[1] =paste(sep="/", yearat[1], moat[1])

        }


      axis(1, at=jdat, labels=yrmolab, las=2, cex=.7)

      if(DAYS)
        {

          ndays = RSEIS::DAYSperYEAR( floor(RX[1]) )
          
          RSEIS::getmoday( ndays*(RX[1]-floor(RX[1])), floor(RX[1]) )

         
          
          Seqday =   seq(from=RX[1], to=RX[2], by=1/ndays)

          GGMD = RSEIS::getmoday( 365*(Seqday-floor(Seqday)), floor(Seqday) )
          XPos = floor(Seqday)+RSEIS::getjul( floor(Seqday)  ,GGMD$mo , GGMD$dom )/365

          XPos = XPos[GGMD$dom!=1]
          ## axis(1, at=XPos, labels=GGMD$dom[GGMD$dom!=1])
          axis(1, at=XPos, labels=GGMD$dom[GGMD$dom!=1])

          ## axis(1, at=XPos, labels=NULL, tcl = 0.5 )
        }
    }
###############################################
