`NewHOZscale` <-
function(z, loc=list(x=0, y=0), col=rainbow(100), units="", font=1, SIDE=1)
  {
    ##########   creates a horizontal color scale for images
    ######   at location loc, if loc is not provided - returns locator(2)
    if(missing(units)) { units="" }
    if(missing(SIDE)) {  SIDE=1}
    if(missing(col)) {  col= rainbow(100) }
    if(missing(font)) {  font=1  }
    if(missing(loc)) {  loc=locator(2) }


    if(is.null(loc)) {  loc=locator(2) }
    u = par("usr")
    f = par("pin")

    raty = (u[4]-u[3])/f[2]

    
    dy = (u[4]-u[3])*.05

#     dy = raty*0.25

    
    dx = (u[2]-u[1])*.3
#    LU=list(x=c(u[1]+dx*0.1, u[1]+dx*0.1+dx), y = c(u[3]-2*dy, u[3]-2*dy - dy))

    LU = loc
    ##    message(paste(sep=' ', 'HOZ SCALE:', LU$x[1], LU$y[1], LU$x[2], LU$y[2])) 
   ##   rect(LU$x[1], LU$y[1], LU$x[2], LU$y[2], xpd=TRUE)

    rngz = range(z, na.rm = TRUE)
    rng = pretty(rngz)
    rng = rng[ rng>=rngz[1] & rng<=rngz[2]  ]

    
    i = seq(along = col)
    BX = (LU$x[2]-LU$x[1])/length(i)
    x1 =LU$x[1]+(i-1)*BX
    x2 = x1+BX
    y1 = LU$y[1]
    y2 =  LU$y[2]
      
    rect(x1,y1,x2,y2,  col=col, xpd = TRUE, border=NA)

    
   alocs = LU$x[1]+(LU$x[2]-LU$x[1])*(rng-rngz[1])/diff(rngz)

    segments(alocs,y1 , alocs, y2)
text(alocs,y2, labels=rng, pos=3, font=font, xpd=TRUE)
text(mean(LU$x),y1, labels=units, pos=1, font=font, xpd=TRUE)

    
 ####    rlab = paste(sep=" ", format.default(rng[2], digits=3), units)
    
####     text(LU$x[2]+BX, (y1+y2)/2, labels=rlab, adj=0, xpd = TRUE)
####     text(LU$x[1]-BX/2,  (y1+y2)/2, labels=format.default(rng[1], digits=3), adj=1, xpd = TRUE)
    rect(LU$x[1], LU$y[1], LU$x[2], LU$y[2], xpd=TRUE)

    invisible(loc)

  }

