`PS.file` <-
function(pref="RPS_", PRINT=TRUE)
{
  ##X##  set up a postscipt file for printing
  if(missing(PRINT)) { PRINT=TRUE }
  if(missing(pref)) {  pref =  "RPS_" }
  i = 0
 
  nam <- paste(pref,formatC(i, format="d", width=3, flag="0"), sep="")
  PSFILE = paste(nam, "eps", sep=".")
  
  while(file.exists(PSFILE)==TRUE)
    {
      i = i+1
      nam <- paste(pref,formatC(i, format="d", width=3, flag="0"), sep="")
      PSFILE = paste(nam, "eps", sep=".")

    }

  if(PRINT)
    {
      cmd = paste("postscript(file=",PSFILE,", print.it=FALSE,  onefile=FALSE)", sep='')
      
      message(cmd)
      message("...." )
      message("dev.off()")
    }
  else
    {

      message("Do Not Forget to...." )
      message("dev.off()")
 
      postscript(file=PSFILE, print.it=FALSE,   paper = "special", onefile=FALSE)

    }
  
  return(PSFILE)

  
}

