`SHOWPAL.A` <-
function(XMCOL, NAME=FALSE, ncol=5, BACK="white", labels=NULL )
  {
    if(missing(NAME)) { NAME=FALSE }
   if(missing(ncol)) { ncol=5 }
   if(missing(BACK)) { BACK="white" }

    
##  RPMG::SHOWPAL(XMCOL)
    N  = length(XMCOL)

    par(mfrow=c(1,1))
    
    
    nrow = ceiling(N/ncol)
    if(nrow<1) { nrow=1  }

   
###   A = RPMG::SHOWPAL.A(COLLIST, NAME=FALSE, ncol=15)

###   A = RPMG::SHOWPAL(COLLIST, NAME=FALSE, ncol=15)


   ###  ncol  = 5
   ###  nrow = 6
    
    dx = 1/ncol
    dy = 1/nrow

    

    mdx = dx*0.1
    mdy = dy*0.1

    
    LX = seq(from=0,  by=dx, length=ncol)
    LY = seq(from=0,  by=dy, length=nrow)

 
    MYMESH  = RPMG::meshgrid(LX, LY)


    cpad = length(MYMESH$x)-length(XMCOL)

    
    if(cpad>0)
      {
    COLS = c(XMCOL, rep(NA, cpad))
  }
    else
      {
        COLS = c(XMCOL)
      }

    ACOLS = matrix(COLS, ncol=length(LX), nrow=length(LY), byrow=TRUE)

    if(BACK=="black")
      {
        cmain = rgb(.7,.7,.7)
        par(bg=rgb(0.1,0.1,0.1), fg=rgb(1,1,1),col.axis=rgb(1,1,1),col.lab=rgb(1,1,1),col.main=cmain ,col.sub=rgb(1,1,1)   )
      }
    else
      {
        cmain = rgb(1-.7, 1-.7, 1-.7)
        par(bg=rgb(1,1,1), fg=rgb(0,0,0),col.axis=rgb(0,0,0),col.lab=rgb(0,0,0),col.main=cmain ,col.sub=rgb(0,0,0)   )
        
      }

    
plot(c(0,1), c(0,1), type='n', axes=FALSE, xlab='', ylab='')
rect( (MYMESH$x), (MYMESH$y) , MYMESH$x+dx-mdx, MYMESH$y+dy-mdy,  col=ACOLS, border="transparent" )
    
    
    
        if(NAME==TRUE)
          {

              
              nums = matrix(1:length(ACOLS), ncol=length(LX), nrow=length(LY), byrow=TRUE)
             if(length(labels)>1)
              {
                  lab = paste(sep=':', nums, labels )
              }
             else
                 {
                     lab = paste(sep=':', nums, ACOLS )
                     }
              lab[is.na(ACOLS)] = NA


              
            text( ((MYMESH$x)+MYMESH$x+dx-mdx)/2, ((MYMESH$y)+ MYMESH$y+dy-mdy)/2    , lab, adj=0.5, col=1)
           


            
          }



    ###   A = RPMG::SHOWPAL.A(COLLIST, NAME=FALSE, ncol=15)
    ###     plot(c(0,1), c(0,1), type='n', axes=FALSE, xlab='', ylab='')
    ###    text( ((A$MYMESH$x)+A$MYMESH$x+A$dx-A$mdx)/2, ((A$MYMESH$y)+ A$MYMESH$y+A$dy-A$mdy)/2    , A$ACOLS, adj=0.5, col=A$ACOLS)

     
    title("Color Palette")
    invisible(list(MYMESH=MYMESH, ACOLS=ACOLS,dx=dx, dy=dy, mdx=mdx, mdy=mdy ))
  }

