catvec<-function(v, icol=5, nsig=5, sep1="\t", sep2=",")
  {
    ##########    v is a vector of numbers
    if(missing(icol))icol=5
    if(missing(nsig))nsig=5
    if(missing(sep1))sep1="\t"
    if(missing(sep2))sep2=","


    
    nr = 1+length(v)/icol
    zig = matrix(NA, ncol=nr, nrow=icol)

    for(i in 1:length(v)) zig[i] = v[i]

    zig = t(zig)

    d = dim(zig)

    for(i in 1:d[1] )
      {
        g = zig[i,]
        g = g[!is.na(g)]
        h = format(g, digits=nsig)
        az = paste(h , collapse=sep1)
        cat(az)
        cat(sep2)
        cat("\n")
      }

    
  }

###  x = round( runif(45, 1, 200) )
####  catvec(x, icol=5, nsig=5, sep1="\t")
####  catvec(x, icol=5, nsig=5, sep1=", ", sep2=",")
####  catvec(rnorm(100) , icol=5, nsig=5, sep1="\t", sep2="")

