chinorm<-function(z, icat=4, p=0.90, verbose=TRUE )
  {
    ##  p confidence level (fraction of 1)
    ##  icat = number of categoriies
    ##   z = normalized data
    if(missing(icat)) icat = 4
    if(missing(p)) p = 0.90
    if(missing(verbose))  verbose=TRUE

    pees = (1:(icat-1))/icat
    ques = qnorm(pees)

    nums = rep(0, length=icat)
    w = z<ques[1]
    nums[1] = length(z[w])
    if(verbose)
      {
        cat(paste(sep=" ", "############GROUP####", 1), sep="\n")
###cat( z[w] , sep=" ")
        catvec(z[w] ,5,5, sep1="\t", sep2="")
        cat( "" , sep="\n")
      }
    for(i in 2:(length(ques))  )
      {
        w = z>ques[i-1] & z<=ques[i]
        nums[i] = length(z[w])

        if(verbose)
          {
            cat(paste(sep=" ", "############GROUP####", i), sep="\n")
###cat( z[w] , sep=" ")
            catvec(z[w] ,5,5, sep1="\t", sep2="")
            cat( "" , sep="\n")
          }
      }
    w = z>ques[icat-1]
    nums[icat] = length(z[w])
    if(verbose)
      {
        cat(paste(sep=" ", "############GROUP####", icat), sep="\n")
###cat( z[w] , sep=" ")
        catvec(z[w] ,5,5, sep1="\t", sep2="")
        cat( "" , sep="\n")
      }
    cat( "" , sep="\n")
###############################################
###############################################
    gexpect = length(z)/icat
    mychi = sum( ((nums-gexpect)^2)/gexpect )
    amychi = format(mychi, digits=5)
    dof = icat - 1 -1 - 1
    q1 = qchisq(p, dof)

    aq1 = format(q1, digits=5)

    cat( "" , sep="\n")
    cat("##################", sep="\n")
    cat(paste(sep=" ","Observed test value:" , amychi), sep="\n")
    cat(paste(sep=" ", "P-value=", p, "with ", dof, "DOF"), sep="\n")
    cat(paste(sep=" ", "Chi Sq Q value:" , aq1), sep="\n")

    if(mychi>q1)
      {
        cat(paste(sep=" ", "REJECT NULL Hypothesis"), sep="\n")
      }
    else
      {
        cat(paste(sep=" ", "FAIL to reject NULL Hypothesis"), sep="\n")
      }

  }
