circWAVES<-function( rad=seq(from=50, to=500, length=10), col='red', ang1=90,
                    npts = 1,  LOC.CEN=list(x=0, y=0) , poly=NA, jinout=1)
    {
### create a set of circular waves
### poly is an x-y polygon list
### jinout =1 (include waves in the polygon)  0=exclude waves in polygon
        
        output = vector(mode='list')
        
        ##### npts = number of points to increment around the circle
        jcirc = RPMG::circle(npts, ang1=ang1)
        for(i in 1:length(rad) )
            {

                EX =    LOC.CEN$x+rad[i]*jcirc$x
                WHY =   LOC.CEN$y+rad[i]*jcirc$y
                if(any( is.na(poly) ) )
                    {
                     jin = rep(1,length=length(EX) )
                    }
                else
                    {
                        jin = GEOmap::inpoly(EX, WHY, poly)
                    }
                EX[jin!=jinout] = NA
                WHY[jin!=jinout]= NA
                output[[i]] = list(x=EX, y=WHY, col=col,
                          border=NA, type='lines', lwd=1, lty=1)     
            }

        output = bounds.icon(output) 
        return(output)


    }
