crunchEQ<-function(INP)
{
##########   read a list of events output from the 
### IRIS site:    http://www.iris.edu/quakes/eventsrch.htm

### geteq612 = scan(file="/home/lees/Site/LaurelCreek/qout.16403310", what="", sep="\n")

### EQLIST = crunchEQ(geteq612)
  
###   source("/home/lees/Progs/R_PAX/JMLUTIL/R/crunchEQ.R")

  
  glist = list()
  for(i in 1:length(INP))
    {
      z1 = unlist(strsplit(INP[i], split="\t"))

      z1 = z1[z1!=""]


      yr = as.numeric(substr(z1[1], 1,4))
      mo = as.numeric(substr(z1[1], 6,7))
      dom = as.numeric(substr(z1[1], 9 ,10))

      hr = as.numeric(substr(z1[1], 12,13))
      mi = as.numeric(substr(z1[1], 15,16))
      sec = as.numeric(substr(z1[1], 18,24))
      lat=as.numeric(z1[2])
      lon=as.numeric(z1[3])
      depth=as.numeric(z1[4])
      mag=as.numeric(z1[5])

      jd = RSEIS::getjul(yr, mo, dom)
      glist[[i]] = list(yr=yr, jd=jd, mo=mo, dom=dom, hr=hr, mi=mi, sec=sec, lat=lat, lon=lon, z=depth, mag=mag)

    }

  dgl = vector()
  for(i in 1:length(glist))
    {
      dgl[i] = glist[[i]]$jd+glist[[i]]$hr/24+glist[[i]]$mi/(24*60)+glist[[i]]$sec/(24*3600)

    }

  return(list(jdays=dgl, glist=glist))
}
