`draw.elipse` <-
function(x,y, r1, r2, phi, theta1=0, theta2=360 , by=5, col=NULL, border="black", add=TRUE , ...)
  {
    if(missing(by)) { by= 5 }
    if(missing(col)) { col=NULL }
    if(missing(border)) { border="black"}

    #######  make a 
   
    theta=seq(from=theta1,to=theta2,by=by)*pi/180
    
    #######  get cosine and sine of orientation
    cosp=cos(phi*pi/180)
    sinp=sin(phi*pi/180)


 
    #######  make a rotation matrix
    r=matrix(c(cosp,-sinp, sinp, cosp), ncol=2)
    #########  create an ellipse
    m=matrix(rep(0,2*length(theta)),ncol=2)

    
    
    m[,1]=r1*cos(theta)
    m[,2]=r2*sin(theta)



    
    #######  rotate ellipse
    nm=m %*% r
    #######  plot lines
    if(add==TRUE)   polygon(x+nm[,1],y+nm[,2], col=col, border=border, ...)

    invisible(list(x=x+nm[,1], y=y+nm[,2]))
    
  }
