`draw.pentstar` <-
function(x,  y, siz=siz, col="black", border=NULL, startalph = -45 )
  {
    if(missing(col)) { col=rep(1,length=length(x)) }
    if(missing(siz)) { siz=rep(.3,length=length(x)) }
    if(missing(border)) { border=NULL }

    if(length(siz)==1) {siz=rep(siz,length=length(x))  }
    if(length(col)==1) {col=rep(col,length=length(x))  }
    if(missing(startalph))   { startalph = -45}
    
    up = par("usr")
    ui = par("pin")

    ratx = (up[2]-up[1])/ui[1]
    raty=  (up[4]-up[3])/ui[2]
    
    p.x = vector(length=6)
    p.y = vector(length=6)

    b.x = vector(length=6)
    b.y = vector(length=6)

    alph = 72*pi/180
    stalph = startalph*pi/180

    ostar = c(1,4,2,5,3,1)
    dis =0.06878314



    for(i in 1:length(x))
      {
	x0 = x[i]	
	y0 = y[i]

        usizx = siz[i]*ratx
        usizy = siz[i]*raty
	for(j in 1:6)
          {
            phi = stalph+(j-1)*alph
            phi2 = stalph+(j-1)*alph+alph/2
            
            p.x[j] =  x0+  (usizx*cos(phi)+usizx*sin(phi))
            p.y[j] = y0+ ( -usizy*sin(phi)+usizy*cos(phi))

            b.x[j] =  x0+  0.381966*(usizx*cos(phi2)+usizx*sin(phi2))
            b.y[j] = y0+  0.381966* ( -usizy*sin(phi2)+usizy*cos(phi2))
          }

	## segments(rep(x[i],5),  rep(y[i],5),  p.x[-6],  p.y[-6])
        ##	segments(rep(x[i],5),  rep(y[i],5),  b.x[-6],  b.y[-6])

        ##	if(!is.null(col[i])) { 	polygon(p.x[ostar], p.y[ostar], col=col[i]) }


        ##	if(!is.null(border)) { lines(p.x[ostar], p.y[ostar], col=border) }

        ##text(p.x, p.y, labels=1:5)
        ##text(b.x, b.y, labels=1:5)

        polygon(c(p.x[1],b.x[5],p.x[5],b.x[4],p.x[4],b.x[3], p.x[3],b.x[2],  p.x[2],b.x[1],p.x[1],b.x[5]) , 
                c(p.y[1],b.y[5],p.y[5],b.y[4],p.y[4],b.y[3], p.y[3],b.y[2],  p.y[2],b.y[1],p.y[1],b.y[5]), 
                col=col[i], border=border)

      }

  }

