`draw.triang` <-
function(x,  y, siz=siz, col="black", border="black" )
  {
    
    if(missing(col)) { col=rep(1,length=length(x)) }
    if(missing(siz)) { siz=rep(.3,length=length(x)) }
    if(missing(border)) { border=rep("black",length=length(x))   }

    up = par("usr")
    ui = par("pin")

    ratx = (up[2]-up[1])/ui[1]
    raty=  (up[4]-up[3])/ui[2]
    if(length(siz)<length(x)) { siz=rep(siz,length=length(x)) }
    if(length(col)<length(x)) { col=rep(col,length=length(x)) }
    if(length(border)<length(x)) { border=rep(border[1],length=length(x)) }

    
    usizx = siz*ratx
    usizy = siz*raty
    cos30 = 0.8660254
    sin30  = 0.5

    for(i in 1:length(x))
      {
        x2 = x[i] - usizx[i] * cos30;
        y2 = y[i] - usizy[i] * sin30;
        x3 = x[i] + usizx[i] * cos30;
        y3 = y[i] - usizy[i] * sin30;
        x4 = x[i];
        y4 = y[i] + usizy[i];
        polygon(c(x2, x3, x4, x2),c(y2, y3, y4, y2), col=col[i], border=border[i]  )
      }
    
  }

