`draw.xplo` <-
    function(x,  y, siz=0.04, col="black", border=NULL, npoints=8, siz2=0.02 )
        {


            if(missing(col)) { col=rep(1,length=length(x)) }
            if(missing(siz)) { siz=rep(.04,length=length(x)) }
            if(missing(siz2)) { siz2=siz/2 }
            
            if(missing(border)) { border=NULL }
            
            if(length(siz)==1) {siz=rep(siz,length=length(x))  }
             if(length(siz2)==1) {siz2=rep(siz2,length=length(x))  }
            
            if(length(col)==1) {col=rep(col,length=length(x))  }
            
            up = par("usr")
            ui = par("pin")
            
            ratx = (up[2]-up[1])/ui[1]
            raty=  (up[4]-up[3])/ui[2]
            
            dang = 2*pi/npoints
            angz = seq(from=0, to=2*pi, by = dang)
            angz = angz[1:npoints]

            angz2 = angz+dang/2

            N = length(angz)+length(angz2)
        
            outer.rim = list( x=cos(angz), y=sin(angz) )
            
            inner.rim = list(x=cos(angz2), y=sin(angz2) )

            xplo = list(x=vector(mode='numeric', length=N), y=vector(mode='numeric', length=N) )
            
            odds = seq(from=1, to=N, by =2)
            evens = seq(from=2, to=N, by =2)

            odds = odds[1:length(outer.rim$x)]
            evens = evens[1:length(inner.rim$x)]

            for(i in 1:length(x))
                {
                    
                    xplo$x[odds] = x[i]+siz[i]*outer.rim$x
                    xplo$x[evens] = x[i]+ siz2[i]*inner.rim$x
                    xplo$y[odds] = y[i]+siz[i]*outer.rim$y
                    xplo$y[evens] = y[i]+siz2[i]*inner.rim$y

                                        #              
                    polygon( xplo, col=col[i], border=border)
                }
        }

