dumpTIKZ<-function(X, dig=5, KOL = 'black', PointsPerLine = 5)
{
    ###### dump out an X-Y list of locations for a tikz drawing
    if(missing(dig)) dig=6
    if(missing(KOL)) KOL = 'black'
       if(missing(PointsPerLine)) PointsPerLine = 5
 
     X =   list(x=signif(X$x, digits = dig ) , y=signif(X$y, digits = dig )  )
    
    cat(paste( '\\draw[color=', KOL ,'] ', sep=''), sep=" ") 
    L =   length(X$x)

    
    for(i  in 1:(L-1)  )
      {
          cat(paste("(", format(X$x[i],  digits = dig) , ",", format(X$y[i],  digits = dig) , ") --" , sep="") )
          if( (i %%  PointsPerLine) == 0 ) cat("\n")
        
      }
    
    i = L
    cat(paste("(", format(X$x[i],  digits = dig) , ",", format(X$y[i],  digits = dig) , "); " , sep=""), sep="\n")
    
  }
