`get.angproj` <-
function(stas, ev)
  {
    ###  given a set of stations with x-y and an event(x-y)
    ###   return a set of all possible event station angles

    K = length(stas$x)

    A = matrix(1:K, ncol=K, nrow=K)

    z1 = A[lower.tri(A)]

    B = t(A)
    z2 = B[lower.tri(A)]

    V1 = list(x=stas$x[z2]-stas$x[z1],    y=stas$y[z2]-stas$y[z1]  )
    V2 = list(x=ev$x-stas$x[z1],    y=ev$y-stas$y[z1] )


    cang1 = acos(  (V1$x*V2$x+V1$y*V2$y)/ (sqrt((V1$x*V1$x+V1$y*V1$y))*sqrt((V2$x*V2$x+V2$y*V2$y))))
    cang2 = 180*cang1/pi
    cang3 = cang2
    cang3[cang2>90] = 180-cang3[cang2>90]
 
    return(list(ang=cang2, cang=cang3,z1=z1, z2=z2, V1=V1, V2=V2))

  }

