getlips2 = function(x1, y1, x2, y2, r1, r2, r3, by=5, MESH)
  {
  ###   source("/home/lees/Progs/R_PAX/JMLUTIL/R/getlips2.R")

    ########   find the ellipsoidal coverage in a plane
 
   
    if(missing(by)) { by= 5 }

  

   dis1 = sqrt( (x1-x2)^2 + (y1-y2)^2)
   
   R = 2*r1
   
   r2 = sqrt((R/2)^2 - (dis1/2)^2)

  ###  message(c(r1, r2))

   inx = mean(c(x1, x2))
   iny = mean(c(y1, y2))
    
    theta=seq(0,360,by=by)*pi/180

   onephi = atan2(y1-y2,x1-x2) 

   beta = onephi
   sinbeta = sin(beta )
   cosbeta = cos(beta)

    if(is.na(sinbeta)) {message(beta);  return(NULL) }
    if(is.na(cosbeta)) {message(beta);   return(NULL)  }

   sinalpha = sin(theta)
   cosalpha = cos(theta)

   X = inx + (r1*cosalpha*cosbeta - r2*sinalpha * sinbeta)
   Y = iny + (r1*cosalpha*sinbeta + r2*sinalpha * cosbeta)


    ##  plot(X, Y, asp=1); abline(v=0, h=0)

   
     v1 = sqrt( (MESH$x-x1)^2+(MESH$y-y1)^2) + sqrt( (MESH$x-x2)^2+(MESH$y-y2)^2)

    PLIP = (v1<R)

    ##  SCAT = matrix(0, ncol=dim(MESH$x)[2], nrow=dim(MESH$x)[1])

    ## SCAT[PLIP] = 1
 ##  image(xo, zo,  z=t(SCAT), add=TRUE)

   
    ex = as.vector(MESH$x[PLIP])
    why = as.vector(MESH$y[PLIP])

    rex = ex-inx
    rhy = why-iny


   r=matrix(c(cosbeta,-sinbeta, sinbeta, cosbeta), ncol=2)

    
   
    RR = cbind(rex,rhy )  %*% solve(r)


    zee = r3*sqrt(1-((RR[,1])/r1)^2-(RR[,2]/r2)^2)


   ##  SCAT = matrix(0, ncol=dim(MESH$x)[2], nrow=dim(MESH$x)[1])

  ##   SCAT[PLIP] = zee


   ##  image(xo, zo, t(SCAT), asp=1);  lines(X, Y);  abline(v=0, h=0)

    return(list(x=X, y = Y, ROT=r, PLIP=PLIP ,zee= zee ))
    
  }


