`jbox` <-
function (x, y, textlist, justify = TRUE, cex = 1, leading = 0.5, box = TRUE, fill=NULL, font=1)
{
  if(missing(fill)) { fill=NULL }
  if(missing(font)) { font=1 }

  OLDpar = par(no.readonly=TRUE)
  
    par(adj = 0)
    textstr <- paste(textlist, collapse = " ")
    words <- strsplit(textstr, " ")[[1]]
    line.height <- strheight("hy", cex = cex) * (1 + leading)
    x.len <- diff(x)
    y.pos <- y
    x.pos <- x[1]
    curword <- 1

    if( !is.null(fill) )
      {
        while (curword < length(words)) {
          
          
          curline <- ""
          curline <- paste(curline, words[curword])
          curword <- curword + 1
          
          while (x.pos + strwidth(paste(curline, words[curword]),
                                  cex = cex) < x[2]) {
            if(is.na(words[curword])) break
            
            curline <- paste(curline, words[curword])
            curword <- curword + 1
          }
          y.pos <- y.pos - line.height
        }
        
         rect(x[1], y + line.height, x[2], y.pos, col=fill)
        
      }


     x.len <- diff(x)
    y.pos <- y
    x.pos <- x[1]
    curword <- 1

    while (curword < length(words)) {
      
        curline <- ""
        curline <- paste(curline, words[curword])
        curword <- curword + 1
          
        while (x.pos + strwidth(paste(curline, words[curword]),
            cex = cex) < x[2]) {
          if(is.na(words[curword])) break
          
            curline <- paste(curline, words[curword])
            curword <- curword + 1
        }

      ####  message(curline)
        curline[which(is.na(curline))] = " "
        
        text(x.pos, y.pos, curline)
        
        y.pos <- y.pos - line.height

    }
    if (box)
        {  rect(x[1], y + line.height, x[2], y.pos) }

  par(OLDpar)
    invisible(c(x[1], y + line.height, x[2], y.pos) )
}

