
makePIXmap<-function(LL, MORE, PLOTPARMS, TOscreen=FALSE, ncut=10 )
  {

      ###  require(GEOmap)
      ###    require(geomapdata)
      ###    require(ETOPO)
      ###    require(WORLDMAP2)

      
      
    HEADER=PLOTPARMS$HEADER
      world2=NULL
      ETOPO2=NULL
    if(is.null(HEADER)) { HEADER = "NOFILEexists" }
    if(is.na(HEADER)) { HEADER = "NOFILEexists" }
  
    
    HTMfile=PLOTPARMS$HTMfile
    imgfile=PLOTPARMS$imgfile

    if(identical(MORE,"") | identical(MORE, "NULL") ) MORE=NULL


 if( !is.list(PLOTPARMS$LOCALES) )
      {
    
    if(!file.exists(PLOTPARMS$LOCALES))
      {
        warning(paste(sep=" ","Warning", PLOTPARMS$LOCALES , "LOCALES fille does not
 exist"))
        message("continuing anyway...")
      }
  }


    
####   LL = c(35.6298770230, 42.3340428297,  11.3941923118, 19.6742015957 )
####  MORE = '/home/lees/Site/Italy/italy_map.R'
    
####   AA = makePIXmap(LL, MORE, PLOTPARMS)
    
###########  make a map

#############    R CMD BATCH makeAmap.R
    LAT1 = as.numeric(LL[1])
    LAT2 = as.numeric(LL[2])
    LON1 = as.numeric(LL[3])
    LON2 = as.numeric(LL[4])

    gLAT = c(LAT1, LAT2 )
    gLON = c(LON1, LON2  )


    NARGS = length(LL)


    cat(paste(sep=" ",  "LATS: ",   paste(gLAT, collapse=" ")) , sep="\n")
    
    cat( paste(sep=" ",  "LONS: ",      paste(gLON, collapse=" ")), sep="\n")



    
    data('world2', package='WORLDMAP2', envir = environment())
    data('ETOPO2', package='ETOPO', envir = environment() )

    PROJ <- GEOmap::setPROJ(2, LAT0 = mean(gLAT) , LON0 = mean(gLON) )

    PLOC <- list( LON=gLON, LAT=gLAT)

    ## w2area = geoarea(world2,  PROJ , ncut=10)

    ## GEOmap::plotGEOmapXY(world2, PROJ=PROJ, LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ) , SEL=w2area,     add=FALSE)
    DOMAP = TRUE
      message(paste('Extracting map strokes=',length(world2$STROKES$num)) )
      
    SMAP  = GEOmap::SELGEOmap(world2, ncut=ncut, acut=c(10, Inf), proj=PROJ, LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ))

    if(length(SMAP$STROKES$num)==0)
        {####  no map?
            warning('No Strokes in MAP: check the region bounds')
            DOMAP=FALSE
        }

    
    
    calcol = GEOmap::settopocol()
    rxy = GEOmap::getGEOperim(  range(PLOC$LON) , range(PLOC$LAT), PROJ, 10 )

    GX = range(rxy$x)
    GY = range(rxy$y)

    LONTIX = pretty(range(PLOC$LON))
    LONTIX = LONTIX[LONTIX>=min(PLOC$LON) & LONTIX<=max(PLOC$LON)  ]

    LATTIX = pretty(range(PLOC$LAT))
    LATTIX = LATTIX[LATTIX>=min(PLOC$LAT) & LATTIX<=max(PLOC$LAT)  ]


    TIX = list(lons= c(PLOC$LON[1],  LONTIX,PLOC$LON[2] ) , lats=c(PLOC$LAT[1], LATTIX,PLOC$LAT[2] )   )



    INCHx =  PLOTPARMS$WIDTH
    INCHy =  INCHx*diff(GY)/diff(GX)


    PIXX =  INCHx*72
    PIXY = round(INCHy*72)


    ## X11(width=INCHx, height=INCHy)

    
    ## GEOmap::plotGEOmapXY(SMAP, LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ),  PROJ =PROJ, add=FALSE , PMAT=PMAT$PMAT)
    cat("please wait, plotting maps...", sep="\n")


    ##psname = jpostscript("AMAP", P=c(INCHx, INCHy) )
    psname = RPMG::local.file(imgfile, "png")

   if(!TOscreen)   RPMG::jpng(file=psname , width = PIXX, height = PIXY)


    
###  par(mai=c(0,0,0,0))

    par(mai=c(0.4,0.4,0,0))

    PMAT <-GEOmap::GEOTOPO(ETOPO2, PLOC , PROJ, calcol$calcol)
#############   get these parameters after the plot has been established
    apin = par("pin")
    afin = par("fin")
    aplt = par("plt")
    usr = par("usr")


    if(DOMAP)
        {
            GEOmap::plotGEOmapXY(SMAP, LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ),  PROJ =PROJ, add=TRUE , PMAT=PMAT$PMAT)
        }


    AA = list(PROJ=PROJ, PMAT=PMAT, pin=apin, plt=aplt, fin=afin, USR=usr, PIXX=PIXX, PIXY=PIXY, INCHX=INCHx, INCHY=INCHy, psname=psname)

#############   add in dots where "hot spots are"
    
    HOTTY =  ADDpix( AA, PLOTPARMS)

    if(identical(HOTTY, 0))
      {
        cat("HOTTY=0, implying no HOT spots, i.e. no pixels to add", sep="\n")
      }
    else
      {
###  the hot spots are switch for bitmap plotting

        if(is.matrix(HOTTY))
             {   rect(HOTTY[,1],HOTTY[,4],  HOTTY[,3],  HOTTY[,2], col='red') }

      }

    if(!is.null(MORE)  )
      {
         cat("adding MORE map stuff ", sep="\n")
       
        
        if(file.exists(MORE))
          {
            cat("MORE is a file", sep="\n")
            assign("PMAT", PMAT, envir = .GlobalEnv)
            assign("PLOC", PLOC, envir = .GlobalEnv)
            assign("PROJ", PROJ, envir = .GlobalEnv)

            
            cat("please wait, adding stuff...", sep="\n" )
            
            cat(paste(sep=" ", "Last arg=", MORE), sep="\n" )
            source(MORE)
          }
          else
            {

               
                  FUN <- match.fun(MORE)
                  
              if(is.function(FUN))
                {
                  cat("MORE is a function", sep="\n")
   
                  FUN(PLOC, PROJ, PMAT) 
                }
              
              

              
              
            }
          
          

          
        
      }
    
    tem = trans3d(rxy$x, rxy$y, rep(0, length(rxy$y)),
      PMAT$PMAT)

    GEOmap::antipolygon(tem$x, tem$y, col='white')


    ticx = diff(PLOC$LAT)*0.01
    ticy = diff(PLOC$LON)*0.01

    GEOmap::addLLXY(TIX$lats, TIX$lons, PROJ=PROJ, PMAT =PMAT$PMAT,   col=rgb(0,0,0) , GRIDcol=NULL , GRID=FALSE ,   LABS=0, TICS=c(ticx, ticy))


    if(!TOscreen) dev.off()

    return(AA)
##########################
  }
########
########  
