`makelines` <-
function(LL)
{
###  locate pairs of points and make lines for abline function
####   usage:  LL=locator()
##############     Mlines = makelines(LL)
############          plot.mlines(Mlines, col=grey(.5), lwd=2, lty=2)
  N = length(LL$x)
  n = N/2
  OUT = matrix(ncol=2, nrow=n)
  for(j in 1:n)
    {
      k = (j-1)*2+1
      ## message(k)
      p1x = LL$x[k]
      p2x = LL$x[k+1]
      p1y = LL$y[k]
      p2y = LL$y[k+1]

      m = (p2y-p1y)/(p2x-p1x)
      b =  p1y-m*p1x
      OUT[j,] = c(m,b)

    }

  return(OUT)

}

