myGMT<-function(LL, PROJ=NULL, PLOC=NULL, PMAT=NULL, SMAP=NULL , do.topo=TRUE, do.map=TRUE, dev=NULL)
  {
    #######  My  Generic Mapping Tool
    if(missing(do.map)) do.map=TRUE
    if(missing(do.topo)) do.topo=TRUE
    if(missing(PROJ))PROJ=NULL
    if(missing(PLOC))PLOC=NULL
    if(missing(PMAT))PMAT=NULL
    if(missing(SMAP))SMAP=NULL
    if(missing(dev))dev=NULL
    
########    replace the popular GMT program
###
    world2=ETOPO2=NULL
    data('world2', package='WORLDMAP2', envir = environment() )
    data('ETOPO2', package='ETOPO', envir = environment()  )

    
    LAT1 = as.numeric(LL[1])
    LAT2 = as.numeric(LL[2])
    LON1 = as.numeric(LL[3])
    LON2 = as.numeric(LL[4])

    gLAT = c(LAT1, LAT2 )
    gLON = c(LON1, LON2  )

    if(is.null(PROJ))
      PROJ <- GEOmap::setPROJ(2, LAT0 = mean(gLAT) , LON0 = mean(gLON) )
    if(is.null(PLOC))
      PLOC <- list( LON=gLON, LAT=gLAT)

    calcol = GEOmap::settopocol()


    if(is.null(SMAP))
      {
        SMAP = GEOmap::SELGEOmap(world2, ncut = 3, acut = c(10, Inf), proj = PROJ, 
          LIM = c(PLOC$LON[1], PLOC$LAT[1], PLOC$LON[2], PLOC$LAT[2]))
      }

    if(is.null(dev))
      {

        dev.new()

      }

    if(do.map)
      {

        GEOmap::plotGEOmapXY(SMAP, PROJ=PROJ, LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ) ,
                     add=FALSE, PMAT=NULL, xlab="km", ylab="km")

      }

    if(do.topo)
      {
        if(is.null(PMAT))
          {
            PMAT  = GEOmap::GEOTOPO(ETOPO2, PLOC , PROJ, calcol$calcol)
          }

        AMAT =  persp(PMAT$xo, PMAT$yo, PMAT$IZ$z, theta = 0, phi = 90, r=4000,
          col=PMAT$Mollist[1:(PMAT$dMOL[1]-1), 1:(PMAT$dMOL[2]-1)] , scale = FALSE,
          ltheta = 90, lphi=30, shade = 1, border = NA, expand=0.004, box = FALSE )
        
        if(do.map)
          {

            GEOmap::plotGEOmapXY(SMAP, PROJ=PROJ,
                         LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2], PLOC$LAT[2] ) , add=TRUE, PMAT=PMAT$PMAT)

          }


#############  now check the added map stuff from the function set above:


        
        
        rxy = GEOmap::getGEOperim(range(PLOC$LON), range(PLOC$LAT), PROJ, 10)
        
        
        tem = trans3d(rxy$x, rxy$y, rep(0, length(rxy$y)), PMAT$PMAT)
        
        
        
        GEOmap::antipolygon(tem$x, tem$y, col = "white")
        LONTIX = pretty(range(PLOC$LON))
        LONTIX = LONTIX[LONTIX >= min(PLOC$LON) & LONTIX <= max(PLOC$LON)]
        LATTIX = pretty(range(PLOC$LAT))
        LATTIX = LATTIX[LATTIX >= min(PLOC$LAT) & LATTIX <= max(PLOC$LAT)]
        TIX = list(lons = c(PLOC$LON[1], LONTIX, PLOC$LON[2]), lats = c(PLOC$LAT[1],
                                                                 LATTIX, PLOC$LAT[2]))
        ticx = diff(PLOC$LAT) * 0.01
        ticy = diff(PLOC$LON) * 0.01

        
        GEOmap::addLLXY(TIX$lats, TIX$lons, PROJ = PROJ, PMAT = PMAT$PMAT,
                col = rgb(0, 0, 0), GRIDcol = NULL, GRID = FALSE, LABS = 0,
                TICS = c(ticx, ticy))


        
      }
    invisible(list(PROJ=PROJ, PLOC=PLOC, PMAT=PMAT, SMAP=SMAP))



  }
