mylill<-function(n, p)
  {
#### n = number of samples
#####    p = critical probability (must be one of .2,  .15,  .10, .05, .01)

    if(n<4) return(NULL)
 ###   from table in Davis, page 617
    alil = matrix( c(4,0.3,0.319,0.352,0.381,0.417,
      5,0.285,0.299,0.315,0.337,0.405,
      6,0.265,0.277,0.294,0.319,0.364,
      7,0.247,0.258,0.276,0.3,0.348,
      8,0.233,0.244,0.261,0.285,0.331,
      9,0.223,0.233,0.249,0.271,0.311,
      10,0.215,0.224,0.239,0.258,0.294,
      11,0.206,0.217,0.23,0.249,0.284,
      12,0.199,0.212,0.223,0.242,0.275,
      13,0.19,0.202,0.214,0.234,0.268,
      14,0.183,0.194,0.207,0.227,0.261,
      15,0.177,0.187,0.201,0.22,0.257,
      16,0.173,0.182,0.195,0.213,0.25,
      17,0.169,0.177,0.189,0.206,0.245,
      18,0.166,0.173,0.184,0.2,0.239,
      19,0.163,0.169,0.179,0.195,0.235,
      20,0.16,0.166,0.174,0.19,0.231,
      25,0.142,0.147,0.158,0.173,0.2,
      30,0.131,0.136,0.144,0.161,0.187), ncol=6, byrow=TRUE)

    gt30=c(NA  , .736 , 	.768 , 	.805 , 	.886 , 	1.031 )
    pees = c(.2,  .15,  .10, .05, .01)

    ap = which(p==pees)
    pcol = ap+1
    if(n>30)
      {
        p = gt30[pcol]/sqrt(n)
      }
    else
      {
        irow = which(n==alil[,1])
        p = alil[irow, pcol]
      }
    return(p)
  }

