`rectgrid`<-
  function(grx, gry, ...)
  {
    ##  given a set of X,Y coordinates
    ##   that represent the centersof a grid, plot the grid
    ##   on the current plot.

    dx = diff(grx)
    nx = length(dx)
    dy = diff(gry)
    ny = length(dy)
    
    upperrightx = grx+c(dx/2, dx[nx]/2)
    upperrighty = gry+c(dy/2, dy[ny]/2)
    lowerleftx = grx-c(dx[1]/2,  dx/2)
    lowerlefty = gry-c(dy[1]/2, dy/2)
    

    MGLL = RPMG::meshgrid(lowerleftx,lowerlefty)
    MGUR = RPMG::meshgrid(upperrightx,upperrighty)
    
    rect(MGLL$x, MGLL$y, MGUR$x,  MGUR$y, ...)

    ## x = 1:10; y = 1:10
    ## plot(c(0, x, 11) ,c(0, y, 11) , type='n')
    ##points(X$x, X$y)

    ##rectgrid(x,y, border='red', lty=2)

    invisible(list(LL=MGLL, UR=MGUR))
  }
