rgb2hsl <- function(r, g, b) {
    ####   return hue saturation and lightness
  val_max <- max(c(r, g, b))
  val_min <- min(c(r, g, b))
  h <- s <- l <- (val_max + val_min) / 2
  if (val_max == val_min){
    h <- s <- 0
  } else {
    d <- val_max - val_min
    s <- ifelse(l > 0.5, d / (2 - val_max - val_min), d / (val_max + val_min))
    if (val_max == r) { h <- (g - b) / d + (ifelse(g < b, 6, 0)) }
    if (val_max == g) { h <- (b - r) / d + 2 }
    if (val_max == b) { h <- (r - g) / d + 4 }
    ## h <- (h / 6) * 360
    h <- h*60
  }
  return(c(h=h, s=s, l=l))
}

