`tufteboxplot` <-
function(istr, OR=1:length(istr), ALAB=FALSE, OL=FALSE)
{
  ##  input:
  ##      istr = structure of values
  ##      OR = ordering of the structure ont eh plot
  ##      ALAB  = attribute for labeling the x-axis
  ##       OL = true/false to plot outliers
###  input is a structure with multiple data sets
######  e.g.: tufteboxplot(a$res)
######  e.g.: tufteboxplot(a$res[a$len>200])
######  e.g.: tufteboxplot(a$res[a$len>1000])
######  e.g.: 
######  e.g.:
######  e.g.: fl = a$len>1 & a$len<1000
######  e.g.: tufteboxplot(a$res[fl], OR=order(a$len[fl]), ALAB=a$len[fl])

  s1 = boxplot(istr, plot=FALSE)
  K = 1:length(s1$stats[3,])

  if(missing(OR)){ OR = K }
  if(missing(ALAB)){ ALAB=FALSE }
  if(missing(OL)){ OL=FALSE }

  #  plot(c(K, K, K, K, K) , c(s1$stats[1, OR], s1$stats[2, OR],s1$stats[3, OR], s1$stats[4, OR], s1$stats[5, OR]   ), type='n' , axes=FALSE, ann=FALSE)

  
  kran = range(K)
  kval = range(s1$stats[, OR])

  if(OL==TRUE)
    {
    kran = range(K)
    kval = range(s1$stats[, OR],s1$out )

    
  }
  ## plot(rbind(K, K, K, K, K) , s1$stats[, OR], type='n' , axes=FALSE, ann=FALSE)
  plot(kran , kval, type='n' , axes=FALSE, ann=FALSE)
  
  ylin = pretty(c(s1$stats[1, OR], s1$stats[2, OR],s1$stats[3, OR], s1$stats[4, OR], s1$stats[5, OR]   ))
  abline(h=ylin, lty=2, col=gray(0.85))

  points(K, s1$stats[3,OR], col=2, pch=3)
  segments(K, s1$stats[1,OR], K, s1$stats[2,OR], col=4)
  segments(K, s1$stats[4,OR], K, s1$stats[5,OR], col=4)
  axis(2)

  ## poser = rep(1,length(K))
  ##  poser[K%%2==0] = 0


   ## ADJ = cbind(poser, rep(0.5,length(K)))

  
  ypnt = s1$stats[1,OR]
  ypnt[K%%2==0] = s1$stats[5,OR[K%%2==0] ]
  ynms = s1$names[OR]
  
  text(K[K%%2==1], ypnt[K%%2==1], labels=ynms[K%%2==1], adj=c(1,0.5), xpd=TRUE, srt=90)

  text(K[K%%2==0], ypnt[K%%2==0], labels=ynms[K%%2==0], adj=c(0,0.5), xpd=TRUE, srt=90)


  if(OL==TRUE)
    {
      kp = s1$out
    }

  

if(length(ALAB)>1)
  {

    axis(1, at=K, labels=ALAB[OR])
  }

  ##  axis(1, at=K, labels=s1$names)
}

