vandCC<-function(InM, weight=TRUE)
{
  if(missing(weight)) { weight=FALSE }
####   cross correlations are stored in the lower triangular
#### the relative phase lags are stored in the upper triangle
####   source("/home/lees/R_PAX/JMLUTIL/R/vandCC.R")

  D = dim(InM)
  ##   message(D)
  
  YY = RPMG::meshgrid(1:D[1], 1:D[1])
  
  ccmask = InM
  ccmask[!upper.tri(ccmask)] = NA
  jx = YY$x[!is.na(ccmask)]
  jy = YY$y[!is.na(ccmask)]

  delt =  InM[cbind(jy, jx)]
  rhs = c(delt, 0)

 ####   message(delt)
  
  n = D[1]
  
  JJ = RPMG::meshgrid(1:n, 1:n)

  N = 1+n*(n-1)/2

  ix = JJ$x[upper.tri(JJ$x)]
  iy = JJ$y[upper.tri(JJ$y)]

  M = matrix(0, ncol=n, nrow=N)

  M[cbind(1:length(ix), ix)] = 1
  M[cbind(1:length(iy), iy)] = -1

  M[N,] = rep(1, n)


  if(weight==FALSE)
    {
      ##  solve(t(M) %*% M) %*% t(M) %*% rhs
      
      t.est = ( t(M) %*% rhs )/n
    }
  else
    {
      We =  t(InM)[cbind(jy, jx)]
      W = diag(c(We, 1) )

## 
##       G = svd( W %*% M )
 
      t.est =  solve(t(M) %*% W %*% M) %*% t(M) %*% W %*% rhs
      
    }

  return(as.vector(t.est))
}

