viewangle<-function(p1, p2)
  {
#####   here p1 and p2 are vectors
###  return the viewing angles for
###    a scene where p1 is the object and p2 is the observer

###  the AZ angle is the angle of rotation about the Z axis
    ###  the INC angle is then a rotation about the X axis
    dx = as.numeric( p1[1]-p2[1] )
    dy = as.numeric( p1[2]-p2[2] )
    dz =  as.numeric(p1[3]-p2[3] )

    viewAZ  = atan2( dy, dx)
    viewazD  = 180*viewAZ/pi
    viewINC = asin(dz/sqrt(dx^2+dy^2+dz^2))
    viewINCD =     180*viewINC/pi

    return(c(AZ=viewAZ,  INC=viewINC, AZDeg=viewazD, INCDeg=viewINCD)) 
    
  }
