\name{EYEVIEW}
\alias{EYEVIEW}
\alias{BDEVIL}
\alias{NC}
\alias{skulnbones}
\alias{TARHEEL}
\alias{bluedevil}
\alias{skull}
\alias{KAMERA1}
\alias{Mike}
\alias{Balloon.icon}
\alias{Tripod}
\alias{Tilt1}
\alias{gps}
\alias{Grav1}
\alias{Drone}
\alias{seismo.icon}

\docType{data}
\title{Symbols for Drawing in leesdraw}
\description{
  These are a set of complex symbols used for drawing
  or printing icons on plots
}
\usage{
data(EYEVIEW)
data(BDEVIL)
data(NC)
data(skulnbones)
data(TARHEEL)
data(bluedevil)
data(KAMERA1)
data(Mike)
data(Balloon.icon)
data(Tripod)
data(Tilt1)
data(gps)
data(Grav1)
data(Drone)
data(seismo.icon)

}
\format{
  List of strokes.  Each stroke is a list consisting of:
  \describe{
  \item{x}{x-coordinates}
  \item{y}{y-coordinates}
  \item{type}{type of stroke: 1=point, 2=line, 3=polygon}
  \item{col}{rgb, color to fill}
  \item{border}{rgb, color for border }
  \item{lwd}{line width}
    \item{note}{information about the stroke}
  }

  
}
\details{
  Strokes are painted in order.  Attributes consist of DX, DY and OUT,
  BG and FG (background and foreground color).
  These can be changed to change the color of the symbol, but the symbol
  can be changed stroke by stroke.  The strokes consist of 'lines' and
  'polygon' types (polygons are filled).
}
\note{
  EYEVIEW is symbol for showing the direction the viewing angle is taking.
  skulnbones draws a pirate skull and bones symbol.
  NC draws a UNC-chapel hill logo.  TARHEEL is the classic tarheel
  which can be flipped for right and left foot.
  bluedevil and BDEVIL are the duke university logos.
  }
  
\seealso{draw.sym, mirror.sym, prep.sym, recentersym, rotate.sym,
  rotsym, draw.circ, Kdraw}

\examples{
\dontrun{
data(EYEVIEW)
Kdraw(EYEVIEW)

################################
data(TARHEEL)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,TARHEEL, siz=.3)


################################
data(skulnbones)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,skulnbones, siz=.3)
################################


data(BDEVIL)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,BDEVIL, siz=.003)

draw.sym(x,y,TARHEEL, siz=.3)

################################
data(bluedevil)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,bluedevil, siz=.003)

draw.sym(x,y,TARHEEL, siz=.3)

################################
data(NC)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,NC, siz=.3)

################################
data(EYEVIEW)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,EYEVIEW, siz=.3)

################################
data(KAMERA1)

x = rnorm(10)
y = rnorm(10)
plot(x,y, type='n')

draw.sym(x,y,KAMERA1, siz=.3)

################################
#######  plot cameras pointing to a target:

 x= runif(10, 1, 10)
     y = runif(10, 1,10)
plot(c(-1, x),c(-1, y),type='n', asp=1)

for(i in 1:length(x))
{
theta = -180*atan2(y[i],x[i])/pi
segments(0,0, x[i], y[i], lty=2, col='blue')

KAMT2 = rotate.sym(KAMERA1, theta=theta, x=0, y=0)

     draw.sym(x[i],y[i], KAMT2, siz=.3)

}

}
}
\keyword{datasets}
