\name{LIMS.icon}
\alias{LIMS.icon}
\title{Get limits of icon X-Y
}
\description{Return the limits of an icon, used for plotting.
}
\usage{
LIMS.icon(x, y, ICON, siz = siz, J=NA)
}
\arguments{
  \item{x}{x location
}
  \item{y}{y location
}
  \item{ICON}{icon
}
  \item{siz}{siz
}
  \item{J}{index of elements to include (NA indecates all)
}

}
\details{
Use this routine to extract the bounds of plotted icon,
used for adjusting location or plotting icons together.
The use of J allows one to find the limits of individual components of the icon.
This may be used for precise location or for putting one icon
in a very exact location on top of another.
}
\value{
\item{KX}{X-Y vectors of icon limits}
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{shift.icon.R, trim.icon.R, rescale.icon.R , prect
}
\examples{

\dontrun{
data(Tripod)
Tripod[[24]]$col='gold'

plot(c(0,1), c(0,1), type='n')
v = LIMS.icon(.5, .4, Tripod, siz = 0.001)
draw.sym(.5, .4, Tripod , siz=0.001  )

prect(v$KX)

v24 = LIMS.icon(.5, .4, Tripod, siz = 0.001, J=24)
prect(v24$KX)

############# plot with camera
data(KAMERA1)
kx = attr(KAMERA1,'DX')
ky = attr(KAMERA1,'DY')

plot(c(0,1), c(0,1), type='n')
draw.sym(.5, .4, Tripod , siz=0.001  )
v24 = LIMS.icon(.5, .4, Tripod, siz = 0.001, J=24)
##  We want the camera to look the right size

cam = rescale.icon(KAMERA1, AX = c(-0.5, 0.5))

siz = 6*diff(v24$KX$x)

draw.sym(mean(v24$KX$x) , max(v24$KX$y), cam , siz=siz  )

############# plot with microphone

data(Mike)
plot(c(0,10), c(0,10), type='n')

siz1 = 0.001
####  or, try siz1 = siz1/2
draw.sym(5, 4, Tripod , siz=siz1  )

v24 = LIMS.icon(5, 4, Tripod, siz = siz1, J=24)

##  We want the camera to look the right size

micr = rescale.icon(Mike, AX = c(-0.5, 0.5))

siz = diff(v24$KX$x)

c4 = LIMS.icon(mean(v24$KX$x) , max(v24$KX$y), micr, siz =siz, J=4)
##### make a slight shift so microphone looks installed
sy = mean(v24$KX$y) - min(c4$KX$y)
sx = mean(v24$KX$x) - mean(c4$KX$x)

draw.sym(mean(v24$KX$x)+sx , max(v24$KX$y)+sy, micr , siz=siz  )



}




}
\keyword{misc}
