\name{MONTHaxis}
\Rdversion{1.1}
\alias{MONTHaxis}
\title{Monthly time axis
}
\description{Add Time axis with months labeled
}
\usage{
MONTHaxis(X, DAYS = FALSE)
}
\arguments{
  \item{X}{Times, in year + julian days
}
  \item{DAYS}{logical, TRUE=add day ticks to axis
}
}
\details{Input data must be in years+days/365.
  Years are marked on January.
}
\value{graphical side effect, adds x-axis
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{axis
}
\examples{

##############  span 5  years
x = seq(from=2003+180/365, to=2008+180/365, by=4/365)
y = rnorm(length(x))

plot(x,y, type='p', axes=FALSE)
axis(2)
box()

MONTHaxis(x, DAYS = FALSE)



##############  span a couple  years
x = seq(from=2003+180/365, to=2005+180/365, by=4/365)
y = rnorm(length(x))

plot(x,y, type='p', axes=FALSE)
axis(2)
box()

MONTHaxis(x, DAYS = FALSE)
##################################  50 days

x = seq(from=2003+180/365, to=2003+230/365, by=4/365)
y = rnorm(length(x))

plot(x,y, type='p', axes=FALSE)
axis(2)
box()

MONTHaxis(x, DAYS = TRUE)


##################################  20 days

x = seq(from=2003+180/365, to=2003+200/365, by=4/365)
y = rnorm(length(x))

plot(x,y, type='p', axes=FALSE)
axis(2)
box()

MONTHaxis(x, DAYS = TRUE)



}
\keyword{misc}
