\name{circWAVES}
\alias{circWAVES}
\title{Create circular waves.
}
\description{
Create circular waves emanating from a point.
}
\usage{
circWAVES(rad = seq(from = 50, to = 500, length = 10), col = "red", ang1 = 90, npts = 1, LOC.CEN = list(x = 0, y = 0), poly = NA, jinout = 1)
}
\arguments{
  \item{rad}{vector, radii in user units.
}
  \item{col}{color
}
  \item{ang1}{Angle, degrees, for starting the circles.
}
  \item{npts}{numeric, number of points per circle
}
  \item{LOC.CEN}{list (x,y) location for the center
}
  \item{poly}{list (x,y) polygon for masking the circles
}
  \item{jinout}{integer (0 or 1), 1=include points in the polygon
}
}
\details{
Returns a list of strokes useful for plotting on cartoons.
}
\value{
ICON structure
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{

\dontrun{
w = circWAVES()
Kdraw(w)


KLOP=list()
KLOP$x=c(7.82268073555, 
7.03386850315, 6.42496081499, 5.41472760507, 4.52904369501, 4.70894823925, 
5.64998739368, 6.35576675951, 7.32448353614, 7.97490765759, 8.23784506839, 
8.62533177904, 8.80523632328)

KLOP$y=c(7.96572526101, 
7.06123006501, 6.22525723235, 6.22525723235, 5.85523647035, 4.95074127436, 
3.9914281877, 3.75845215237, 3.73104320703, 4.05995055103, 4.63553840303, 
6.12932592369, 7.45865977234)




w1 = circWAVES( rad=seq(from=0, to=4, length=20), col='blue', ang1=90,
                    npts = 1,  LOC.CEN=list(x=4, y=4) , poly=KLOP, jinout=1)

Kdraw(w1)




}

}
\keyword{misc}
