\name{crunchEQ}
\alias{crunchEQ}
\title{Get data from USGS web site and decompose}
\description{
  Extracts infromation from download from site:
  http://www.iris.edu/quakes/eventsrch.htm
  and decomposes this for input to travel time calculations
}
\usage{
crunchEQ(INP)
}
\arguments{
  \item{INP}{Files saved from website}
}
\details{
  date is in format loaded
  from IRIS site:    http://www.iris.edu/quakes/eventsrch.htm.
  scan this into R, and crunch....
 
}
\value{
  \item{jdays}{start times of events in decimal Julian Days}
  \item{glist}{same information as lists of yr, jd, mo, dom, hr, mi, sec}
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\examples{

\dontrun{
### IRIS site:    http://www.iris.edu/quakes/eventsrch.htm

geteq612 = scan(file="/home/lees/Site/LaurelCreek/qout.16403310", what="", sep="\n")

EQLIST = crunchEQ(geteq612)

}

}
\keyword{misc}
