\name{draw.circ}
\alias{draw.circ}
\alias{draw.NC}
\alias{draw.pent}
\alias{draw.pentstar}
\alias{draw.rect}
\alias{draw.star5}
\alias{draw.sym}
\alias{draw.triang2}
\alias{draw.triang}
\alias{draw.volc}
\alias{draw.xplo}


\title{Draw Symbols on the current plot}
\description{
 Draw Symbols on the current plot
}
\usage{
draw.circ(x, y, r, ...)
draw.pent(x,  y, siz=siz, col="black", border=NULL, startalph = -45)
draw.pentstar(x,  y, siz=siz, col="black", border=NULL, startalph = -45)
draw.star5(x,  y, siz=siz, col="black", border=NULL)
draw.sym(x,  y, sym, siz=siz, 
col=rgb(83/255, 157/255, 194/255), border="black" , ...)
draw.triang2(x,  y, siz=siz, col="black", border="black")
draw.triang(x,  y, siz=siz, col="black", border="black")
draw.volc(x,  y, siz=siz, col="black", border="black")
draw.NC(x,  y, siz=siz, col=rgb(83/255, 157/255, 194/255), border="black" )
draw.xplo(x,  y, siz=0.04, col="black", border=NULL, npoints=8, siz2=0.02 )

}

\arguments{
  \item{x}{x-coordinate}
  \item{y}{y-coordinate}
  \item{r}{radius or size}
  \item{siz}{size of object}
  \item{col}{fill color}
  \item{border}{border color}
  \item{sym}{drawing function describing a symbol }
    \item{startalph}{starting rotation angle for stars}
  \item{npoints}{number of points in the explosion icon}
  \item{siz2}{inner circle for the explosion}
  
  \item{\dots}{graphical parameters from par}

}
\details{
  Add to current plot these symbols.
  
}
\value{
 Graphical Side Effects
}
\seealso{draw.tarheel}

\author{Jonathan M. Lees<jonathan.lees.edu>}

\examples{

x= 1:10
y = x^2
plot(x,y, type='n')
draw.circ(x,y, .1)


x= runif(10)
y = runif(10)
plot(x,y, type='n', asp=1)
draw.star5(x,y, .05, col='red', border='blue' )

x= runif(10)
y = runif(10)
plot(x,y, type='n', asp=1)
draw.pentstar(x,y, .1, col='red', border='blue')
x= runif(10)
y = runif(10)
draw.pentstar(x,y, .1, col='green', border='blue', startalph = -20)



x= runif(10)
y = runif(10)
plot(x,y, type='n', asp=1)
draw.triang2(x,y, .1, col="red" , border='blue')

x= runif(10)
y = runif(10)
draw.triang(x,y, .1, col=NULL, border='purple' )



x= runif(10)
y = runif(10)
plot(x,y, type='n', asp=1)
draw.volc(x,y, .4, col="blue", border="red")

x= runif(10)
y = runif(10)
plot(x,y, type='n', asp=1)
draw.xplo(x,y, siz=0.04, col="blue", border="red", npoints=8, siz2=0.02 )






}

\keyword{aplot}
