\name{draw.elipse}
\alias{draw.elipse}
\title{Draw ellipse}
\description{Draw an ellipse on the current plot
}
\usage{
draw.elipse(x,y, r1, r2, phi, theta1=0, theta2=360 , by=5, col=NULL, border="black", add=TRUE , ...)

}
\arguments{
  \item{x}{x-coordinate center}
  \item{y}{y-coordinate }
  \item{r1}{major axis}
  \item{r2}{minor axi}
  \item{phi}{angle of rotation, degrees}
  \item{theta1}{starting angle, degrees}
  \item{theta2}{ending angle, degrees}
  \item{by}{increment for plotting}
  \item{col}{color}
  \item{border}{color}
  \item{add}{ logical, whether to add to existing plot, default=TRUE}
  \item{\dots}{graphic parameters}
}

\note{
Theta1 and theta2 must be increasing, e.g. theta1=130 to theta2=360+30.
  }

\value{
  graphical side effects, coordinates of the ellipse
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{getlips}
\examples{

dumplot()

draw.elipse(.2,.7, .2, .1, 60, by=5, col=rgb(1, .8, .8) ,
border='black')

###  get elipse coords and draw
J = draw.elipse(.7,.3, .2, .1, 0, by=5,theta1=130, theta2=360+30, col=NULL,
    add=FALSE,  border='black')
lines(J)

}
\keyword{misc}
