\name{getlips}
\alias{getlips}
\title{Get Ellipsoid values}
\description{
  Get Ellipsoid values
}
\usage{
getlips(inx, iny, r1, r2, r3, onephi, by = 5, MESH)
}
\arguments{
  \item{inx}{x location}
  \item{iny}{y location }
  \item{r1}{major axis}
  \item{r2}{minor axis}
  \item{r3}{z axis}
  \item{onephi}{angle}
  \item{by}{increment for ellipse}
  \item{MESH}{meshgrid for selection}
}

\value{
  List:
  \item{x}{x coordinates for ellipse}
  \item{y}{y coordinates for ellipse}
  \item{ROT}{rotation matrix}
  \item{PLIP}{index of MESH that are internal to ellipse}
   \item{zee}{zee values at PLIP}
 

  
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}


\examples{

MESH = RPMG::meshgrid(1:200, 1:200)

p = getlips(50, 100, 40, 10, 10, 65, by = 5, MESH)
SCAT = matrix(0, ncol=dim(MESH$x)[1], nrow=dim(MESH$x)[2])
SCAT[p$PLIP==0] = NA
SCAT[p$PLIP==1] = p$zee

image(x=1:200, y=1:200, z=t(SCAT), col=rainbow(100))




}
\keyword{misc}
