\name{getlips2}
\alias{getlips2}
\title{Get ellipse2}
\description{
  generate an ellipse given the foci and major axis
}
\usage{
getlips2(x1, y1, x2, y2, r1, r2, r3, by = 5, MESH)
}
\arguments{
  \item{x1}{x-coordiante focus 1}
  \item{y1}{y-coordiante focus 1 }
  \item{x2}{x-coordiante focus 2 }
  \item{y2}{y-coordiante focus 2 }
  \item{r1}{major axis}
  \item{r2}{semi minor axis (not used) }
  \item{r3}{semi minor axis in z-direction }
  \item{by}{increment around ellipse }
  \item{MESH}{Mesh to match to }
}
\details{
  
  The semi minor axis is calcualted to insure that
  curve is really an ellipse.  When r3 is provided,
  an ellipsoidal image is created on the Mesh.
}
\value{
  
  \item{x}{x-coordiantes}
  \item{y}{y-coordiantes}
 \item{ROT}{rotation matrix}
 \item{PLIP}{index of MESH that are inside ellipse}
 \item{zee}{z-values for ellipsoidal surface}

  
}
\author{Jonathan M. Lees<jonathan.lees@unc.edu>}
\note{
 The function can be used for creating an
  image of covered regions by adding ellipsoids.
  
  
}

\examples{

xo = seq(from=-150, to=150, by=1)
yo = xo

MESH = RPMG::meshgrid(xo, yo)


x1 =runif(10, -150, 150)
x2 =runif(10, -150, 150)
y1 =runif(10, -150, 150)
y2 =runif(10, -150, 150)

dis = sqrt( (x2-x1)^2+ (y2-y1)^2)


r = dis+runif(10, 1, 20)
A3 = r/2


############  first example:

plot(range(xo), range(yo), type='n', axes=FALSE, ann=FALSE, asp=1)
box()
axis(1)
axis(2)

segments(x1,y1, x2,y2, col='blue')


for(i in 1:length(x1))
{
glip  = getlips2(x1[i], y1[i], x2[i], y2[i], r[i], 1, A3[i], by=5, MESH)
if(!is.null(glip))
{

lines(glip$x, glip$y)

}
}

############  image example:
SCATNT = matrix(0, ncol=dim(MESH$x)[1], nrow=dim(MESH$x)[2])
for( i in 1:length(x1) )
{
   
glip  = getlips2(x1[i], y1[i], x2[i], y2[i], r[i], 1, A3[i], by=5, MESH)
SCATNT[glip$PLIP==1] = glip$zee+SCATNT[glip$PLIP==1] 


}
SCATNT[SCATNT==0] = NA

plot(range(xo), range(yo), type='n', axes=FALSE, ann=FALSE, asp=1)
box()
axis(1)
axis(2)

image(x=xo, y=yo, z=t(SCATNT),add=TRUE)





}


\keyword{misc}
