\name{makePIXmap}
\alias{makePIXmap}
\title{Make a map and add hot pixels in html format }
\description{
  Make a png image map and add hot pixels in html format
}
\usage{
makePIXmap(LL, MORE, PLOTPARMS, TOscreen=FALSE, ncut=10)
}
\arguments{
  \item{LL}{vector, Lat(LL), LAT(UR), LON(LL), LON(UR) }
  \item{MORE}{File with extra plotting command suitable for GEOmap plots }
  \item{PLOTPARMS}{
    \describe{
      item{LL}{LAT-LONs for choosing an area for the image}
      item{HEADER}{file location of header information}
      item{HTMfile}{file location of output html}
      item{Title1}{title for HTML}
      item{imgfile}{name of image file (will be png format)}
      item{LOCALES}{file of Lat-Lon localities}
      item{mapbar}{link for internal html reference}
      item{WIDTH}{width in Inches of plot}
      item{DP}{number of pixels for the }
    }
  }
    \item{TOscreen}{If TRUE, plot will be directed to current window on screen, default=FALSE}
    \item{ncut}{Limit strokes in map to those that have greater than ncut points }

}
\details{
  Need to set up locales and MORE in advance.
}
\value{
 Side Effect: produces a png image and an html file.
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{ADDpix, makeHTMLmap}
\examples{

\dontrun{

wash.func<-function(PLOC, PROJ, PMAT)
{
library(geomapdata)
data(USAmap)
plotGEOmapXY(USAmap,
LIM=c(PLOC$LON[1], PLOC$LAT[1],PLOC$LON[2],PLOC$LAT[2] ),PROJ =PROJ,
      add=TRUE , PMAT=PMAT$PMAT)
##########  add in volcano points
vees = GLOB.XY( c(46.87,  46.20    ),  c(-121.758, -122.18), PROJ)
JML = trans3d(vees$x, vees$y, rep(0, length(vees$y)),
                PMAT$PMAT)
points(JML$x, JML$y, pch=2, cex=2)
text(JML$x, JML$y, labels=c( "Rainier", "St. Helens") , pos=3)
}

LL = c(45.4 , 49.0, 235.0, 243.0  )
  MORE = 'wash.func'

HEADER = NA
    HTMfile = "Washington_Loc.html"

Title1 = "Washington"
imgfile  = "Washington_Loc"

##  washlocales = scan(file="/home/lees/WEB/Wwash.locales", list(lon=0, lat=0, name="", txt="",  img="", URL="" ))
washlocales=list()
washlocales$'lon'=c(-121.750397,-122.160637)
washlocales$'lat'=c(46.860729,46.19817)
 washlocales$name=c( "Rainier" ,       "Mt. St. Helens")
washlocales$txt=c( "Mt. Rainier Volcano, WA",    "Mt. St. Helens Volcano, WA")
washlocales$img=c( "Rainier_53_smallb.jpg", "MSH.thumb.JPG")

washlocales$URL=c(
"http://www.unc.edu/~leesj/abstracts.html#Moranetal99",
"http://www.unc.edu/~leesj/Tomographic\%20inversion\%20of\%20Mt.htm")


LOCALES = washlocales

mapbar = "Washingtonbar"

DP=c(10,10)   ####   pixel thickness of hot spot
WIDTH=8      ####   width of plot in inches

PLOTPARMS = list(LL=LL, HEADER=HEADER,HTMfile=HTMfile,Title1=Title1,
     imgfile=imgfile, LOCALES=LOCALES,mapbar=mapbar, WIDTH=WIDTH, DP=DP  )


 AA = makePIXmap(LL, MORE, PLOTPARMS)


}





}
\keyword{misc}
