\name{rgb2hsl}
\alias{rgb2hsl}
\title{RGB color to HSL
}
\description{Convert an RGB designation to
a Hue-Saturation-Lightness
}
\usage{
rgb2hsl(r, g, b)
}
\arguments{
  \item{r}{numeric,  red, 0-255
}
  \item{g}{numeric, green, 0-255
}
  \item{b}{numeric, blue, 0-255
}
}
\details{Used for determining the brightness of a color,
so one can find a complement for printing text.
}
\value{vector, hsl values
}
\references{
\url{http://www.niwa.nu/2013/05/math-behind-colorspace-conversions-rgb-hsl}
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{col2rgb
}
\examples{

######  for a set of colors, find the light versus the dark ones
xpal = RPMG::setXMCOL()
jkol = col2rgb(xpal)
vox = matrix(ncol=3, nrow=length(jkol[1,]))
for(i in 1:length(jkol[1,]) )
    {

    hhssll = rgb2hsl(jkol[1,i], jkol[2,i], jkol[3,i])
    vox[i,] = hhssll
    }

let.col = rep('black', length=length(xpal) )
let.col[ vox[,3]<(255/2) ] = 'white'


\dontrun{

YN = RPMG::OPTREPLOT(xpal, ncol = 5, cols = xpal, scol = 'black', 
bcol = 'white', cex = 0.8, newplot = TRUE)
mpct = 0.1
dx = YN$dx
dy = YN$dy
mdx = dx * mpct
mdy = dy * mpct


par(bg='black', fg='white')
plot(YN$rx, YN$ry, type = "n", axes = FALSE, xlab = "", 
ylab = "", main = '')

rect(YN$M$x + mdx, YN$M$y + mdy, YN$M$x + dx - mdx, YN$M$y + dy - mdy, 
border = NA, col = xpal, lwd = 1)

text( (YN$M$x + mdx + YN$M$x + dx - mdx)/2 , ( YN$M$y + mdy + YN$M$y + dy - mdy)/2,
labels=xpal, col=let.col)

}




}
\keyword{misc}
