\name{rotate.sym}
\alias{rotate.sym}
\title{Rotate Symbol by theta degrees}
\description{Rotate Symbol by theta degrees
}
\usage{
rotate.sym(KALL, theta = 0, x=0, y=0)
}
\arguments{
  \item{KALL}{Symbol list}
  \item{theta}{angle, degrees}
  \item{x}{x-coordinate}
   \item{y}{y-coordinate}
  
}

\value{
  Returns the input structure rotated by theta degrees
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{mirror.sym, recentersym, prep.sym}
\examples{

\dontrun{

data(skulnbones)

T3 = rotate.sym(skulnbones, 90)

x= rnorm(10)
y = rnorm(10)

plot(x,y,type='n')
draw.sym(x,y,T3, siz=.4)


################################
#######  plot cameras pointing to a target:


data(KAMERA1)

 x= runif(10, 1, 10)
     y = runif(10, 1,10)
plot(c(-1, x),c(-1, y),type='n', asp=1)

for(i in 1:length(x))
{
theta = -180*atan2(y[i],x[i])/pi
segments(0,0, x[i], y[i], lty=2, col='blue')

KAMT2 = rotate.sym(KAMERA1, theta=theta, x=0, y=0)

     draw.sym(x[i],y[i], KAMT2, siz=.3)

}

}
}
\keyword{aplot}
