\name{vane.glyph}
\alias{vane.glyph}
\title{Add a N-S arrow on a map}
\description{Add a N-S arrow on a map (weather vane)
}
\usage{
vane.glyph(x, y= NULL, R = 1, col.arrow = 1, col.N = 1, col.circ = 1, rot = 0,  LET='N',  PMAT=NULL)
}
\arguments{
  \item{x}{x-coordinate}
  \item{y}{y-coordinate}
  \item{R}{radius}
  \item{col.arrow}{color for arrow}
  \item{col.N}{color for N}
  \item{col.circ}{color for circle}
  \item{rot}{rotation angle}
  \item{LET}{Text letter to plot (usually N or S)}
  \item{PMAT}{Rotation matrix, output of function persp}
}

\value{
 Graphical Side Effects
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}


\examples{
 plot(c(0, 1), c(0, 1), main = "this is a test", sub = "sutitle",
        xlab = "this is x", ylab = "this is y", asp=1, type='n')

	vane.glyph(.5, .5, R =.3, col.arrow = 'blue', col.N = 'red', col.circ =
	'green', rot = 0)

	vane.glyph(.1, .1, R =.1, col.arrow = 'blue', col.N = 'red', col.circ =
	'white', LET='S', rot = 0)

	##########  more with rotational examples:
N = 10
gr =  runif(N, 0, 180)
rr = runif(N, .2, 1.2)

plot(c(-1, 11), c(-1,11) , type='n' , asp=1)
for(i in 1:N)
    {
        vane.glyph(x=i, y=i , R=rr[i], rot=gr[i], col.arrow='dodgerblue', col.N='yellow', col.circ='red', LET='N', PMAT=NULL)
          vane.glyph(x=i, y=i+2 , R=rr[i], rot=gr[i]+180, col.arrow='green', col.N='gold', col.circ='blue', LET='S', PMAT=NULL)
       
    }


}
\keyword{misc}
