MY2DFILT <-
function(fftA2, kx1, ky1, FL)
  {
    ## require(splancs)

    
##############   2D filter
    ##########    fftA2 is the 2D fft of an image not shifted
    ######   kx1 and kx2 are the x and y axes respectively
    ###############  they are set to go from -0.5 to +0.5-(one freq sample)
    #####   FL is a mask for filtering
    ###  FL is designed to be only the first half of the filter -
    ###   mirror image is created by the program
    #######   for example:  -0.5000000  0.4983361


    PLOT = FALSE 
    d = dim(fftA2)

    
    FFLP = list(x=-FL$x, y=-FL$y)

    ##########   set up a masking
    MK = RPMG::meshgrid(kx1, ky1)

    ######  determine what points are in or out of the polygons

    MYPOINTS = cbind(as.vector(MK$x) , as.vector(MK$y) )

    MYpoly =  cbind(FL$x, FL$y)
    I1 = splancs::inout(MYPOINTS , MYpoly  ,bound=NULL,quiet=TRUE)


    ####  take care of wrap around

    if(any(FL$x>0.5))
       {
         F1 = splancs::inout(MYPOINTS , cbind(1-FL$x, FL$y)  ,bound=NULL,quiet=TRUE)
         I1 = I1 | F1
       }
    
    if(any(FL$x<(-0.5)))
       {
         F2 = splancs::inout(MYPOINTS , cbind(1+FL$x, FL$y)  ,bound=NULL,quiet=TRUE)
         I1 = I1 | F2
       }
    

    
    MYpoly =  cbind(FFLP$x, FFLP$y) 
    I2 = splancs::inout(MYPOINTS   ,  MYpoly   ,bound=NULL,quiet=TRUE)

      if(any(FFLP$x>0.5))
       {
         F1 = splancs::inout(MYPOINTS , cbind(1-FFLP$x, FFLP$y)  ,bound=NULL,quiet=TRUE)
         I2 = I2 | F1
       }
    
    if(any(FFLP$x<(-0.5) ))
       {
         F2 = splancs::inout(MYPOINTS , cbind(1+FFLP$x, FFLP$y)  ,bound=NULL,quiet=TRUE)
         I2 = I2 |  F2
       }
    


    #########   reorganize vectors into matrix form
    
    mI1 = matrix(I1, nrow=d[1], ncol=d[2], byrow=TRUE)
    mI2 = matrix(I2, nrow=d[1], ncol=d[2], byrow=TRUE)

    MASK = mI1|mI2

    HO = matrix(rep(1, times=d[1]*d[2])  , nrow=d[1], ncol=d[2], byrow=TRUE)

    HO[MASK] = 0

    if(PLOT)
      {
    image(x=kx1, y=ky1, HO, col=rainbow(100), asp=1)
    
    plot(MK$x, MK$y, pch=".")
    points(MK$x[MASK], MK$y[MASK], pch=".", col='blue', cex=2)
  }
    

    ##############   here apply the mask

    OO = fftA2
    OO[ mI1] = 0.0+0.0i
    OO[ mI2] = 0.0+0.0i

    #######  return the 
    KKF =fft( OO , inverse = TRUE)

    
    return(KKF)
  }

