MY2DFILTC <-
function(fftA2, kx1, ky1, FL)
  {
   ##  require(splancs)

    
##############   2D filter
    ##########    fftA2 is the 2D fft of an image not shifted
    ######   kx1 and kx2 are the x and y axes respectively
    ###############  they are set to go from -0.5 to +0.5-(one freq sample)
    #####   FL is a mask for filtering
    ###  FL is designed to be only the first half of the filter -
    ###   mirror image is created by the program
    #######   for example:  -0.5000000  0.4983361


    d = dim(fftA2)

    #######  reflect through origin
    FFLP = list(x=(-FL$x), y=(-FL$y) )

    ##########   set up a masking
    MK = RPMG::meshgrid(kx1, ky1)

    ######  determine what points are in or out of the polygons

    MYPOINTS = cbind(as.vector(MK$x) , as.vector(MK$y) )

    MYpoly =  cbind(FL$x, FL$y)
    I1 = inout(MYPOINTS , MYpoly  ,bound=NULL,quiet=TRUE)

    MYpoly =  cbind(FFLP$x, FFLP$y) 
    I2 = inout(MYPOINTS   ,  MYpoly   ,bound=NULL,quiet=TRUE)

     

    #########   reorganize vectors into matrix form
    
    mI1 = matrix(I1, nrow=d[1], ncol=d[2], byrow=TRUE)
    mI2 = matrix(I2, nrow=d[1], ncol=d[2], byrow=TRUE)

    MASK = mI1|mI2

    HO = matrix(rep(1, times=d[1]*d[2])  , nrow=d[1], ncol=d[2], byrow=TRUE)

    HO[MASK] = 0

  ###  image(x=kx1, y=ky1, HO, col= terrain.colors(100) , asp=1)
  ###  abline(v=0, h=0)


   ix1 = 1:(d[1]/2)
ix2 = (1+(d[1]/2)):d[1]

iy1 = 1:(d[2]/2)
iy2 = (1+(d[2]/2)):d[2]


Z1 = rbind(HO[ix2, iy2], HO[ix1, iy2])

Z2 = rbind(HO[ix2, iy1], HO[ix1, iy1])


ZO = cbind(Z1, Z2)

    

    ##############   here apply the mask

    OO = fftA2
    OO[ZO==0 ] = 0.0+0.0i
  #####  OO[ mI2] = 0.0+0.0i

    #######  return the 
    KKF =fft( OO , inverse = TRUE)

    
    return(KKF)
  }

