filtpoly2D <-
  function(fftA2, col=rainbow(100), FL , scale=0 )
  {
    if(missing(col)) { col = rainbow(100) } 
    if(missing(scale)) scale = 1




    ZEE = Mod(fftA2)
    
    if(scale==1){
      ZEE = log(1+ Mod(fftA2))
    }

    if(scale==0){
      ZEE = Mod(fftA2)
    }

    if(scale==2){
      ZEE = log( Mod(fftA2) )
    }
    if(scale==3){
      ZEE = sqrt( Mod(fftA2) )
    }



    
    PARMS = getKXKY(fftA2)

    
    d = PARMS$d
    
    dx = PARMS$dx
    dy = PARMS$dy

    
    kx1  = PARMS$kx

    
    ky1  =  PARMS$ky


    image(x=kx1, y=ky1, ZEE , col=col , asp=1 )

    
    abline(v=0, h=0)

   
    if(missing(FL)) { FL = locator(type='p') } 

    polygon(FL$x, FL$y, col=NA, border='black')

########  flip the filter for the conjugate side:

    FFLP = list(x=max(kx1)-FL$x-0.5, y=max(ky1)-FL$y-0.5)

    polygon(FFLP$x, FFLP$y, col=NA, border='black')


    
    invisible(list(FL=FL, kx1=kx1, ky1=ky1, d=d) )

  }

