getKXKY<-function(fftA2, dx=1, dy=1)
  {
    ###  given a 2D FT return vectors of the kx and ky axes

    if(missing(dx) ) dx = 1
    if(missing(dy) ) dy = 1


    d = dim(Mod(fftA2))
    
    
    fn1 = 1/(2*dx)

    jitter1 =  2*fn1/(d[1])
    kx1  = (seq(from=-fn1, to=fn1- jitter1 , length=d[1]))

    fn2 = 1/(2*dy)
    jitter2 = 2*fn2/(d[2])
    ky1  = (seq(from=-fn2 , to=fn2-jitter2 , length=d[2]))

    return(list(kx=kx1, ky=ky1, d=d, dx=dx, dy=dy))

  }


