jimage.info<-function(y2, PLOT=FALSE)
{
  if(missing(PLOT)) { PLOT=FALSE }
  
  cl = attr(y2, "class")
  siz = attr(y2, "size")
  bbox = attr(y2, "bbox")
  cres = attr(y2, "cellres")
  chans = attr(y2, "channels")

  if(PLOT)
    {
      op <-par(no.readonly = TRUE) 
      if(cl=="pixmapGrey")
        {
          z = attr(y2, "grey")
          hist(as.vector(z))
        }

      if(cl=="pixmapRGB")
        {
          zred = attr(y2, "red")
          zgreen = attr(y2, "green")
          zblue = attr(y2, "blue")
          
          par(mfrow=c(3,1))
          hist(as.vector(zred), col='red', xlab="Red", xlim=c(0,1) )
          hist(as.vector(zgreen), col='green', xlab="Green", xlim=c(0,1))
          hist(as.vector(zblue), col='blue', xlab="Blue" , xlim=c(0,1))

         

          
        }

       par(op)
    }

  
  
  


 return(list(cl=cl, siz=siz, bbox=bbox, cres=cres, chans=chans))


}
