pass2DFILT <-
function(fftA2, kx1, ky1, FL, IO=1)
  {
    ## require(splancs)

    
##############   2D filter
    ##########    fftA2 is the 2D fft of an image not shifted
    ######   kx1 and kx2 are the x and y axes respectively
    ###############  they are set to go from -0.5 to +0.5-(one freq sample)
    #####   FL is a polygon mask for filtering

 ###    IO = is InOut : 1 = delete in (lowpass) ; else delete out  (hipass)

    d = dim(fftA2)

    ##########   set up a masking
    MK = RPMG::meshgrid(kx1, ky1)

    ######  determine what points are in or out of the polygons

    MYPOINTS = cbind(as.vector(MK$x) , as.vector(MK$y) )

    MYpoly =  cbind(FL$x, FL$y)
    I1 = splancs::inout(MYPOINTS , MYpoly  ,bound=NULL,quiet=TRUE)


    ##############   here apply the mask

    OhOh = fftA2
    if(IO==1)
        {
            OhOh[I1] = 0.0+0.0i
        }
    else
        {
            OhOh[!I1] = 0.0+0.0i
        }

    #######  return the 
    KKF =fft( OhOh , inverse = TRUE)

    return(KKF)
  }

