quick2Dfilt<-function(mzup, cutpt = 0.45, gr = grey(0:100/100) )
    {
        d2 = dim(mzup)

        Fmand = ddfft(mzup)

        FAB = fft(mzup)

        PARMS = getKXKY(FAB)
        nyqpt = 0.5

        AFL2 =list(d=d2, kx1=PARMS$kx, ky1=PARMS$ky)

        ########  polygon for filtering
        AFL2$FL =
            list(
                x = c(  -cutpt,  -nyqpt  , -nyqpt, -cutpt,
                    cutpt,  nyqpt, nyqpt , cutpt ),
                y = c(  -nyqpt,  -cutpt  ,  cutpt,  nyqpt,
                    nyqpt , cutpt , -cutpt,      -nyqpt )
            )
        
        ###    Low Pass Filter (delete high frequencies)
        Fsmo = pass2DFILT(FAB  , PARMS$kx, PARMS$ky, AFL2$FL, IO=1)
        ####  high pass filter (delete low frequencies)
        Fsmo2 = pass2DFILT(FAB  , PARMS$kx, PARMS$ky, AFL2$FL, IO=2)

        ZREC = Re(Fsmo)/(2*length(mzup))
        ZREC2 = Re(Fsmo2)/(2*length(mzup))

        par(mfrow=c(1,3))
        image(mzup, col=gr, asp=1, axes=FALSE, ann=FALSE)

        image(ZREC, col=gr, asp=1, axes=FALSE, ann=FALSE)


        image(ZREC2, col=gr, asp=1, axes=FALSE, ann=FALSE)

        
        invisible(list(LO.P=ZREC, HI.P=ZREC2) )

    }
