show2dfft <-
function(fftA2,dx=1, dy=1, scale=1, col=rainbow(100), xlim=NULL, ylim=NULL )
  {

    if(missing(dx)) dx = 1
    if(missing(dy)) dy = 1
    if(missing(scale)) scale = 1



    

    if(missing(col)) { col = grey(0:100/100)  }
    
    ZEE = Mod(fftA2)
    
    if(scale==1){
      ZEE = log(1+ Mod(fftA2))
    }

    if(scale==0){
      ZEE = Mod(fftA2)
    }

    if(scale==2){
      ZEE = log( Mod(fftA2) )
    }
    if(scale==3){
      ZEE = sqrt( Mod(fftA2) )
    }

    d = dim(ZEE)
    
   
    fn1 = 1/(2*dx)
    
    jitter1 =  2*fn1/(d[1])
    kx1  = (seq(from=-fn1, to=fn1- jitter1 , length=d[1]))
    
    fn2 = 1/(2*dy)
    jitter2 = 2*fn2/(d[2])
    ky1  = (seq(from=-fn2 , to=fn2-jitter2 , length=d[2]))

    if(missing(xlim))  xlim=range(kx1)
    if(missing(ylim)) ylim=range(ky1)
    if(is.null(xlim))  xlim=range(kx1)
    if(is.null(ylim)) ylim=range(ky1)
    if(is.na(xlim[1]))  xlim=range(kx1)
    if(is.na(ylim[1])) ylim=range(ky1)
    
    
    
    image(x=kx1, y=ky1, ZEE, col=col, asp=1, axes=FALSE,  ann=FALSE, xlim=xlim, ylim=ylim)
    axis(1, at=pretty(c(-fn1, fn1) ), pos=min(ky1))
    axis(2, at=pretty(c(-fn2, fn2) ),  pos=min(kx1))

    

    invisible(list(kx=kx1, ky=ky1, scale=scale) )
  }

