\name{MY2DFILTC}
\Rdversion{1.1}
\alias{MY2DFILTC}
\title{Create a 2d Mask 
}
\description{
  Apply 2D filter as a mask.
}
\usage{
MY2DFILTC(fftA2, kx1, ky1, FL)
}
\arguments{
  \item{fftA2}{2D FT of an image
}
  \item{kx1}{wavenumbers in X
}
  \item{ky1}{wavenumbers in Y
}
\item{FL}{Mask for filter.  This is a polygon determined from
  a plot of the 2DFT.
}
}
\details{
  points in side the Polygon are
  zeroed out.
}
\value{Matrix: Inverse FT of the input FT.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{ddfft, filtpoly2D
}
\examples{

gr = grey(0:100/100)

tee = 0:127

A = matrix(ncol=128, nrow=128)

zx = row(A)-1
zy = col(A)-1

freq = 16

A =  20*cos(2*pi*zy/freq )

phix=0
phiy=20


Arot =  10*(cos(2*pi*(zy+phiy)/freq + 2*pi*(zx+phix)/freq ) )

AB = A + Arot
par(mfrow=c(2,2))

image(A, col=gr, asp=1); title("first signal")
image(Arot, col=gr, asp=1); title("second signal")
image(AB, col=gr, asp=1); title("Combined signal")

##############################   now apply analysis to Combined signals
par(mfrow=c(2,2))

image(AB, col=gr, asp=1)
title("original image")

FAB = fft(AB)

PARMS = getKXKY(FAB)

image(x=PARMS$kx, y =PARMS$ky,     Mod(FAB), col=rainbow(100), asp=1)

AFL = list()
AFL$FL=list()
AFL$FL$x=c(-0.458355373569,-0.454061731431,-0.408978488980,-0.419712594325)
AFL$FL$y=c(-0.451918307738,-0.396431041790,-0.393908893338,-0.462006901547)





 ##  for interactive, use:    AFL = filtpoly2D(FAB, col=rainbow(100), scale=0)

polygon(AFL$FL$x, AFL$FL$y, col=NA, border='black')

FFLP = list(x=max(PARMS$kx)-AFL$FL$x-0.5, y=max(PARMS$ky)-AFL$FL$y-0.5)

    polygon(FFLP$x, FFLP$y, col=NA, border='black')

Fsmo = MY2DFILTC(FAB  , PARMS$kx, PARMS$ky, AFL$FL)
title("FT or image showing polygons to be removed")

image(Re(Fsmo), col=gr, asp=1)
title("filtered image")


}
\keyword{misc}
