\name{costap}
\Rdversion{1.1}
\alias{costap}
\title{2D Cosine taper
}
\description{2D Cosine taper
}
\usage{
costap(z, r1, r2)
}
\arguments{
  \item{z}{2D image
}
  \item{r1}{inner radius, pixels
}
  \item{r2}{outer radius, pixels
}
}
\details{This is for tapering an  image so it
  does not reach the edge and thus does not suffer
  bad wrapping effects when doing a 2D FT.
  The theory behind the FT is that the input image is assumed to be
  periodic - but if the pattern does not match on the edges this
  assumption introduces noise.
  The taper reduces this effect somewhat.
}
\value{original image with cosine taper applied.
}
\references{http://www.cs.unm.edu/~brayer/vision/fourier.html
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Noise still remains.
}


\seealso{ddfft
}
\examples{

phix=0
phiy=20
gr = grey(0:100/100)

tee = 0:127
freq = 16
a = 10*cos(2*pi*tee/freq )
MT = RPMG::meshgrid(tee, tee)


Arot =  1*(cos(2*pi*(MT$y+phiy)/freq/1.5 + 2*pi*(MT$x+phix)/freq/1.5 ) )


A2d = ddfft(Arot)

d = dim(Arot)

dex = seq(from=-d[1]/2, by=1, length=d[1])
dwhy = seq(from=-d[2]/2, by=1, length=d[2])

M =  RPMG::meshgrid(dex, dwhy)



w2 = matrix(1, ncol=d[1], nrow=d[2])

dis2 = M$x^2+M$y^2

dis = sqrt(dis2)


sig = 35 
w2 = exp( -dis2/sig^2)

w2[dis<sig ] = 1


w2 = costap(sqrt( dis2 )  , 45, 60)



Brot = Arot*w2

B2d = ddfft(Brot)


par(mfrow=c(2,2))
par(mai=c(.5, .4, 0.2, 0.1))
image(Brot, col=gr, asp=1)
show2dfft(B2d, scale=0, col=topo.colors(100)  )
title("Raw Periodogram")
show2dfft(B2d, scale=1, col=topo.colors(100)  )
title("Log(1+Mod)")
show2dfft(A2d, scale=1, col=topo.colors(100)  )
title("Non-tapered Log(1+Mod)")


}
\keyword{misc}
