\name{ddfft}
\Rdversion{1.1}
\alias{ddfft}
\title{
  Two dimensional Fourier Transform
}
\description{Two dimensional Fourier Transform
}
\usage{
ddfft(z)
}
\arguments{
  \item{z}{The 2D fourier transform
}
}
\details{The FT is shifted so the transform  can be centered.
}
\value{ The 2D Fourier-Transform
}
\references{
Gonzalez & Wintz (1977) Digital Image Processing p.53;

}


\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{show2dfft
}
\examples{

gr = grey(0:100/100)

tee = 0:127

A = matrix(ncol=128, nrow=128)

zx = row(A)-1
zy = col(A)-1

freq = 16


par(mfrow=c(2,2))

A =  10*cos(2*pi*zy/freq )
image(A, col=gr, asp=1)


B =  10*cos(2*pi*zx/(freq/2) )
image(B, col=gr, asp=1)


B2d = ddfft(B)
A2d = ddfft(A)
sfs =  show2dfft(B2d, col=topo.colors(100)  )
sfs =  show2dfft(A2d, col=topo.colors(100) )





}
\keyword{misc}
