\name{filtdesign2D}
\Rdversion{1.1}
\alias{filtdesign2D}
\title{Interactive 2D-Filter Design
}
\description{Interactive 2D-Filter Design.  Design a 2D wavenumber
  domain filter by
  clicking in the 2DFT.
}
\usage{
filtdesign2D(MYIMAG, scale=0)
}
\arguments{
  \item{MYIMAG}{image matrix}
  \item{scale}{integer, scaling flag for 2DFT, default=0, Modulus is plotted}
  
}
\details{The interactive program allows the user to click in the fourier
  domain and filter
  the image.  Filtering is done in the wavenumber domain.  The work is done by the routine: MY2DFILT.
}
\value{Filtered image
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{The image is plotted with a default palette.
}


\seealso{MY2DFILT, filtpoly2D, fft
}
\examples{


###  this iprogram is interactive, so needs to run on
#######     X11 or other window, and uses locator
\dontrun{
data(glena)
z = attr(glena, 'grey')
zup = t(z[rev(1:512), ])

zup = zup-mean(zup)


AFL = filtdesign2D(zup)
}



}
\keyword{misc}
